import { View, Text, Pressable, StyleSheet } from 'react-native';
import React from 'react';
import { orderHistoryStyle } from './OrderHistoryStyle';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';
import { useNavigation } from '@react-navigation/native';
import useProcessPrice from '../../../hooks/useProcessPrice';
import DotIcon from '../../../assets/svgs/order history/dot.svg';
import { useSelector } from 'react-redux';
import useLangTranslation from '../../../hooks/useLangTranslation';
import CustomSVG from '../../../src/components/CustomSVG/CustomSVG';


const SingleOrder = ({ item, index }) => {
    const { trans } = useLangTranslation();
    const { myOrders } = useSelector((state) => state.getMyOrdersSlice);
    const navigation = useNavigation();
    const processPrice = useProcessPrice();
    const { id, order_key, created_at, total, status } = item || {};

    const handleOrderDetails = () => {
        navigation.navigate('order details', {
            itemId: id,
        });
    };

    const dotSize = dpr(6);
    return (
        <Pressable
            android_ripple={{ color: 'gray' }}
            onPress={() => handleOrderDetails()}
            style={[
                orderHistoryStyle.item,
                orderHistoryStyle.mb20Optional(myOrders.length, index)
            ]}
        >
            <View style={orderHistoryStyle.header}>
                <Text
                    style={[
                        orderHistoryStyle.headerText,
                        singleOrderStyle.orderId,
                    ]}
                >
                    #{order_key}
                </Text>
                <Text
                    style={[
                        orderHistoryStyle.headerText,
                        singleOrderStyle.orderId,
                    ]}
                >
                    {processPrice(total)}
                </Text>
            </View>
            <View style={orderHistoryStyle.info}>
                <View style={orderHistoryStyle.infoTextCont}>
                    <CustomSVG svgIcon={DotIcon}
                        height={dotSize}
                        width={dotSize}
                        fill={'#C4C4C4'}
                    />
                    <Text style={orderHistoryStyle.infoText}>
                        {created_at}
                    </Text>
                </View>
                <View style={orderHistoryStyle.infoTextCont}>
                    <CustomSVG svgIcon={DotIcon}
                        height={dotSize}
                        width={dotSize}
                        fill={'#C4C4C4'}
                    />
                    <Text style={orderHistoryStyle.infoText}>{trans(status)}</Text>
                </View>
            </View>
        </Pressable>
    );
};

export default SingleOrder;

const singleOrderStyle = StyleSheet.create({
    orderId: {
        width: null,
    },
});
